<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "rb_kvalif_410";

// Establish connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    echo json_encode(["error" => "Database connection failed: " . $conn->connect_error]);
    exit;
}

session_start();
header('Content-Type: application/json');

// Validate user session
if (!isset($_SESSION['user_id'])) {
    echo json_encode(["error" => "User not logged in."]);
    exit;
}

$user_id = $_SESSION['user_id'];
$action = $_POST['action'] ?? null;

// Helper function for sending JSON responses
function sendResponse($success = null, $error = null, $data = null)
{
    $response = [];
    if ($success) $response['success'] = $success;
    if ($error) $response['error'] = $error;
    if ($data) $response['data'] = $data;
    echo json_encode($response);
    exit;
}

// Handle clock-in action
if ($action === "clock-in") {
    $date = date('Y-m-d');
    $time = date('H:i:s');

    $sql = "INSERT INTO rb_kvalif_workhours_410 (user_id, date, clock_in_time) VALUES (?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iss", $user_id, $date, $time);

    if ($stmt->execute()) {
        sendResponse("Clocked in at $time successfully.");
    } else {
        sendResponse(null, "Failed to clock in: " . $stmt->error);
    }

    $stmt->close();
}

// Handle clock-out action
if ($action === "clock-out") {
    $date = date('Y-m-d');
    $time = date('H:i:s');

    $sql = "UPDATE rb_kvalif_workhours_410 
            SET clock_out_time = ?, 
                total_work_hours = TIMESTAMPDIFF(SECOND, CONCAT(date, ' ', clock_in_time), CONCAT(date, ' ', ?)) / 3600
            WHERE user_id = ? AND date = ? AND clock_out_time IS NULL";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssis", $time, $time, $user_id, $date);

    if ($stmt->execute()) {
        if ($stmt->affected_rows === 0) {
            sendResponse(null, "No active clock-in record found for clock out.");
        }
        sendResponse("Clocked out at $time successfully.");
    } else {
        sendResponse(null, "Failed to clock out: " . $stmt->error);
    }

    $stmt->close();
}

// Fetch work hours
$sql = "SELECT date, clock_in_time, 
               IF(clock_out_time IS NULL, 'N/A', clock_out_time) AS clock_out_time,
               IF(clock_out_time IS NULL, 'In Progress', FORMAT(total_work_hours, 2)) AS total_work_hours
        FROM rb_kvalif_workhours_410 
        WHERE user_id = ? ORDER BY date DESC";

$stmt = $conn->prepare($sql);
if ($stmt) {
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $work_hours = $result->fetch_all(MYSQLI_ASSOC);
    sendResponse(null, null, $work_hours);
} else {
    sendResponse(null, "Failed to fetch work hours: " . $conn->error);
}

$stmt->close();
$conn->close();
